/*---------------------------------------------------------------------------+
| PMSPYABT.C                                                                 |
+----------------------------------------------------------------------------+
|                                                                            |
| Window Procedure to display the PMSPY Logo
|
+-------------------------------------+--------------------------------------+
|                                     |   Steve Diering (DIERING at RALVM14) |
| Version: 2.01                       |   Research Triangle Park, NC         |
+-------------------------------------+--------------------------------------+
| History:                                                                   |
| --------                                                                   |
|                                                                            |
| created: aug 31 1989 by steve diering                                      |
+---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------+
| Includes                                                                   |
+---------------------------------------------------------------------------*/

#include "pmspy.h"                      /* Resource symbolic identifiers*/

MRESULT EXPENTRY SpyLogoDlgProc(register HWND   hwnd,
                                register USHORT msg,
                                         MPARAM mp1,
                                         MPARAM mp2)

{
  switch(msg)
  {
    case WM_CLOSE:

         WinDismissDlg(hwnd,NULL);

         break;

    /********************************************************************************
    **
    ** WM_INITDLG:
    **
    ** - Position window in center of Desk Top
    **
    ********************************************************************************/

    case WM_INITDLG:                                /* Display Caption & edits      */
         {
                    HWND   abouthwnd;               /* child window handle(for about dialog) */

                    ULONG  style;                   /* window style in reserved window word's memory */

                    HPOINTER hicon;                 /* handle of the program icon */

                    RECTL  rectlDesktop,            /* Rectl of DeskTop win        */
                           rectlClient;             /* Rectl of Client  win        */

           /*****************************************************************
           * We will now add the PMSPY icon to the about dialog box area by
           * issuing the following PM commands:
           ******************************************************************/

           abouthwnd=WinWindowFromID(               /* Get the window icon    */
                                hwnd,               /*   Parent window Handle */
                                IDD_ABOUTICON);     /*   Child ID             */

           style=WinQueryWindowULong(               /* Get the window style   */
                                     abouthwnd,     /*   About Window Handle  */
                                     QWL_STYLE);    /*   ULong to get is window style  */

           WinSetWindowULong(                       /* Set the window style   */
                             abouthwnd,             /*   About Window Handle  */
                             QWL_STYLE,             /*   ULong to set         */
                             style & (~SS_TEXT) |   /*   Value to set         */
                             SS_ICON);

           hicon=WinLoadPointer(                     /* Get the window icon   */
                                HWND_DESKTOP,        /*   DeskTop Window hand */
                                NULL,                /*   Resource Module hand*/
                                ID_MAINWND);         /*   Res ID or ptr to be loaded */

           WinSendDlgItemMsg(                /* Send msg to dialog item, ABOUTICON  */
                             hwnd,           /*   Parent Window Handle(dialog)*/
                             IDD_ABOUTICON,  /*   dialog item ID              */
                             SM_SETHANDLE,   /*   message ID                  */
                             (MPARAM)hicon,  /*   parm1 is ptr from res file  */
                             NULL);          /*   msg parm2 is NULL           */

           /* Gather information on the DESKTOP */

           WinQueryWindowRect(                    /* Get rect of Dialog           */
                  HWND_DESKTOP,                   /*   Dialog handle              */
                  &rectlDesktop);                 /*   rect                       */

           WinMapWindowPoints(                    /* Convert from desktop to win  */
                  hwndClient,                     /*   window  handle             */
                  HWND_DESKTOP,                   /*   desktop handle             */
                  (PPOINTL)&rectlDesktop,         /*   points                     */
                  2);

           /* Gather information on the LOGO dialog */

           WinQueryWindowRect(                    /* Get rect of Dialog           */
                  hwnd,                           /*   Dialog handle              */
                  &rectlClient);                  /*   rect                       */

           WinMapWindowPoints(                    /* Convert from desktop to win  */
                 hwnd,                            /*   window  handle             */
                 HWND_DESKTOP,                    /*   desktop handle             */
                 (PPOINTL)&rectlClient,           /*   points                     */
                 2);

           /* Position LOGO in center of Desk Top
           **
           ** Centered X position = (Width (DeskTop) - Width (Logo) ) / 2
           ** Centered Y position = (Height(DeskTop) - Height(Logo) ) / 2
           */

           WinSetWindowPos(                       /* Set position of dlg          */
                  hwnd,                           /*   Dialog handle              */
                  HWND_TOP,                       /*   Z_ORDER                    */
                  (SHORT)(                        /*   X position                 */
                          ((rectlDesktop.xRight - /*     Desktop height */
                            rectlDesktop.xLeft) -
                           (rectlClient .xRight - /*     Client  height */
                            rectlClient .xLeft))/2
                         ),

                  (SHORT)(                        /*   Y position                  */
                          ((rectlDesktop.yTop   - /*     Desktop width  */
                            rectlDesktop.yBottom) -
                           (rectlClient .yTop   - /*     Client  width  */
                            rectlClient .yBottom))/2
                         ),

                  (SHORT)NULL,
                  (SHORT)NULL,
                  SWP_MOVE | SWP_ZORDER);         /*   Flags                      */
         }
         break;

    /********************************************************************************
    **
    ** WM_COMMAND:
    **
    ** - switch on user command value
    **
    ********************************************************************************/

    case WM_COMMAND:

         switch ( SHORT1FROMMP(mp1) )
         {
           /********************************************************************************
           ** OK pressed:
           ********************************************************************************/

           case DID_OK:

                WinDismissDlg(hwnd, TRUE);

                break;

           default:
                return WinDefWindowProc( hwnd, msg, mp1, mp2 );
         }

         break;

    default:

         return(WinDefDlgProc(hwnd, msg, mp1, mp2));
  }

  return((MPARAM)NULL);
}
